<?php
if (!defined('ABSPATH')) {
    exit;
}

// Register settings with sanitization
function x402_register_settings()
{
    register_setting('x402_options_group', 'x402_wallet', array('sanitize_callback' => 'sanitize_text_field'));
    register_setting('x402_options_group', 'x402_price', array('sanitize_callback' => 'sanitize_text_field'));
    register_setting('x402_options_group', 'x402_api_url', array('sanitize_callback' => 'esc_url_raw'));
    register_setting('x402_options_group', 'x402_telemetry_url', array('sanitize_callback' => 'esc_url_raw'));
}
add_action('admin_init', 'x402_register_settings');

// Add menu page
function x402_register_options_page()
{
    add_options_page(
        '402gate Settings',
        '402gate',
        'manage_options',
        '402gate',
        'x402_options_page_html'
    );
}
add_action('admin_menu', 'x402_register_options_page');

// Settings page HTML
function x402_options_page_html()
{
    if (!current_user_can('manage_options')) {
        return;
    }
    ?>
    <div class="wrap">
        <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
        <form action="options.php" method="post">
            <?php
            settings_fields('x402_options_group');
            do_settings_sections('x402_options_group');
            ?>
            <table class="form-table">
                <tr valign="top">
                    <th scope="row"><label for="x402_wallet">Merchant Wallet Address</label></th>
                    <td>
                        <input type="text" id="x402_wallet" name="x402_wallet"
                            value="<?php echo esc_attr(get_option('x402_wallet')); ?>" class="regular-text" />
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row"><label for="x402_price">Price (USDC)</label></th>
                    <td>
                        <input type="text" id="x402_price" name="x402_price"
                            value="<?php echo esc_attr(get_option('x402_price')); ?>" class="regular-text" />
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row"><label for="x402_api_url">Backend API URL</label></th>
                    <td>
                        <input type="url" id="x402_api_url" name="x402_api_url"
                            value="<?php echo esc_attr(get_option('x402_api_url')); ?>" class="regular-text"
                            placeholder="http://localhost:3000" />
                        <p class="description">Adres URL twojego backendu 402gate (np. http://localhost:3000)</p>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row"><label for="x402_telemetry_url">Telemetry URL</label></th>
                    <td>
                        <input type="url" id="x402_telemetry_url" name="x402_telemetry_url"
                            value="<?php echo esc_attr(get_option('x402_telemetry_url')); ?>" class="regular-text"
                            placeholder="http://localhost:4000/collect" />
                        <p class="description">Adres URL serwera telemetrii (np. http://localhost:4000/collect)</p>
                    </td>
                </tr>
            </table>
            <?php submit_button(); ?>
        </form>
    </div>
    <?php
}
